/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import pro.gravit.utils.helper.VerifyHelper;

public class ProviderMap<R> {
    protected final Map<String, Class<? extends R>> PROVIDERS = new ConcurrentHashMap<String, Class<? extends R>>(4);
    protected final String name;
    protected boolean registredProviders = false;

    public ProviderMap(String string) {
        this.name = string;
    }

    public ProviderMap() {
        this.name = "Unnamed";
    }

    public String getName() {
        return this.name;
    }

    public void register(String string, Class<? extends R> clazz) {
        VerifyHelper.verifyIDName(string);
        VerifyHelper.putIfAbsent(this.PROVIDERS, string, Objects.requireNonNull(clazz, "adapter"), String.format("%s has been already registered: '%s'", this.name, string));
    }

    public Class<? extends R> getClass(String string) {
        return this.PROVIDERS.get(string);
    }

    public String getName(Class<? extends R> clazz) {
        for (Map.Entry<String, Class<R>> entry : this.PROVIDERS.entrySet()) {
            if (!entry.getValue().equals(clazz)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Class<? extends R> unregister(String string) {
        return this.PROVIDERS.remove(string);
    }
}

