/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.unix.solaris;

import com.sun.jna.platform.unix.solaris.Kstat2;
import com.sun.jna.platform.unix.solaris.LibKstat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.driver.linux.proc.ProcessStat;
import oshi.driver.unix.solaris.Who;
import oshi.jna.platform.unix.SolarisLibc;
import oshi.software.common.AbstractOperatingSystem;
import oshi.software.os.FileSystem;
import oshi.software.os.InternetProtocolStats;
import oshi.software.os.NetworkParams;
import oshi.software.os.OSProcess;
import oshi.software.os.OSService;
import oshi.software.os.OSSession;
import oshi.software.os.OSThread;
import oshi.software.os.OperatingSystem;
import oshi.software.os.unix.solaris.SolarisFileSystem;
import oshi.software.os.unix.solaris.SolarisInternetProtocolStats;
import oshi.software.os.unix.solaris.SolarisNetworkParams;
import oshi.software.os.unix.solaris.SolarisOSProcess;
import oshi.software.os.unix.solaris.SolarisOSThread;
import oshi.util.Constants;
import oshi.util.ExecutingCommand;
import oshi.util.GlobalConfig;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.unix.solaris.KstatUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
public class SolarisOperatingSystem
extends AbstractOperatingSystem {
    private static final String VERSION;
    private static final String BUILD_NUMBER;
    private static final boolean ALLOW_KSTAT2;
    public static final boolean HAS_KSTAT2;
    private static final Supplier<Pair<Long, Long>> BOOT_UPTIME;
    private static final long BOOTTIME;

    @Override
    public String queryManufacturer() {
        return "Oracle";
    }

    @Override
    public Pair<String, OperatingSystem.OSVersionInfo> queryFamilyVersionInfo() {
        return new Pair<String, OperatingSystem.OSVersionInfo>("SunOS", new OperatingSystem.OSVersionInfo(VERSION, "Solaris", BUILD_NUMBER));
    }

    @Override
    protected int queryBitness(int n) {
        if (n == 64) {
            return 64;
        }
        return ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("isainfo -b"), 32);
    }

    @Override
    public FileSystem getFileSystem() {
        return new SolarisFileSystem();
    }

    @Override
    public InternetProtocolStats getInternetProtocolStats() {
        return new SolarisInternetProtocolStats();
    }

    @Override
    public List<OSSession> getSessions() {
        return USE_WHO_COMMAND ? super.getSessions() : Who.queryUtxent();
    }

    @Override
    public OSProcess getProcess(int n) {
        List<OSProcess> list = this.getProcessListFromProcfs(n);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public List<OSProcess> queryAllProcesses() {
        return this.queryAllProcessesFromPrStat();
    }

    @Override
    public List<OSProcess> queryChildProcesses(int n) {
        List<OSProcess> list = this.queryAllProcessesFromPrStat();
        Set<Integer> set = SolarisOperatingSystem.getChildrenOrDescendants(list, n, false);
        return list.stream().filter(oSProcess -> set.contains(oSProcess.getProcessID())).collect(Collectors.toList());
    }

    @Override
    public List<OSProcess> queryDescendantProcesses(int n) {
        List<OSProcess> list = this.queryAllProcessesFromPrStat();
        Set<Integer> set = SolarisOperatingSystem.getChildrenOrDescendants(list, n, true);
        return list.stream().filter(oSProcess -> set.contains(oSProcess.getProcessID())).collect(Collectors.toList());
    }

    private List<OSProcess> queryAllProcessesFromPrStat() {
        return this.getProcessListFromProcfs(-1);
    }

    private List<OSProcess> getProcessListFromProcfs(int n) {
        ArrayList<OSProcess> arrayList = new ArrayList<OSProcess>();
        File[] fileArray = null;
        if (n < 0) {
            File object = new File("/proc");
            fileArray = object.listFiles(file -> Constants.DIGITS.matcher(file.getName()).matches());
        } else {
            File file2 = new File("/proc/" + n);
            if (file2.exists()) {
                fileArray = new File[]{file2};
            }
        }
        if (fileArray == null) {
            return arrayList;
        }
        for (File file3 : fileArray) {
            int n2 = ParseUtil.parseIntOrDefault(file3.getName(), 0);
            SolarisOSProcess solarisOSProcess = new SolarisOSProcess(n2, this);
            if (solarisOSProcess.getState() == OSProcess.State.INVALID) continue;
            arrayList.add(solarisOSProcess);
        }
        return arrayList;
    }

    @Override
    public int getProcessId() {
        return SolarisLibc.INSTANCE.getpid();
    }

    @Override
    public int getProcessCount() {
        return ProcessStat.getPidFiles().length;
    }

    @Override
    public int getThreadId() {
        return SolarisLibc.INSTANCE.thr_self();
    }

    @Override
    public OSThread getCurrentThread() {
        return new SolarisOSThread(this.getProcessId(), this.getThreadId());
    }

    @Override
    public int getThreadCount() {
        List<String> list = ExecutingCommand.runNative("ps -eLo pid");
        if (!list.isEmpty()) {
            return list.size() - 1;
        }
        return this.getProcessCount();
    }

    @Override
    public long getSystemUptime() {
        return SolarisOperatingSystem.querySystemUptime();
    }

    private static long querySystemUptime() {
        if (HAS_KSTAT2) {
            return BOOT_UPTIME.get().getB();
        }
        try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
            LibKstat.Kstat kstat = kstatChain.lookup("unix", 0, "system_misc");
            if (kstat != null && kstatChain.read(kstat)) {
                long l = kstat.ks_snaptime / 1000000000L;
                return l;
            }
        }
        return 0L;
    }

    @Override
    public long getSystemBootTime() {
        return BOOTTIME;
    }

    private static long querySystemBootTime() {
        if (HAS_KSTAT2) {
            return BOOT_UPTIME.get().getA();
        }
        try (KstatUtil.KstatChain kstatChain = KstatUtil.openChain();){
            LibKstat.Kstat kstat = kstatChain.lookup("unix", 0, "system_misc");
            if (kstat != null && kstatChain.read(kstat)) {
                long l = KstatUtil.dataLookupLong(kstat, "boot_time");
                return l;
            }
        }
        return System.currentTimeMillis() / 1000L - SolarisOperatingSystem.querySystemUptime();
    }

    private static Pair<Long, Long> queryBootAndUptime() {
        Object[] objectArray = KstatUtil.queryKstat2("/misc/unix/system_misc", "boot_time", "snaptime");
        long l = objectArray[0] == null ? System.currentTimeMillis() : (Long)objectArray[0];
        long l2 = objectArray[1] == null ? 0L : (Long)objectArray[1] / 1000000000L;
        return new Pair<Long, Long>(l, l2);
    }

    @Override
    public NetworkParams getNetworkParams() {
        return new SolarisNetworkParams();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<OSService> getServices() {
        File[] fileArray2;
        File[] fileArray;
        ArrayList<OSService> arrayList = new ArrayList<OSService>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        File file = new File("/etc/init.d");
        if (file.exists() && file.isDirectory() && (fileArray = file.listFiles()) != null) {
            void string;
            fileArray2 = fileArray;
            int n = fileArray2.length;
            boolean bl = false;
            while (string < n) {
                File n2 = fileArray2[string];
                arrayList2.add(n2.getName());
                ++string;
            }
        }
        fileArray2 = ExecutingCommand.runNative("svcs -p");
        block1: for (String string : fileArray2) {
            if (string.startsWith("online")) {
                int stringArray = string.lastIndexOf(":/");
                if (stringArray <= 0) continue;
                String string2 = string.substring(stringArray + 1);
                if (string2.endsWith(":default")) {
                    string2 = string2.substring(0, string2.length() - 8);
                }
                arrayList.add(new OSService(string2, 0, OSService.State.STOPPED));
                continue;
            }
            if (string.startsWith(" ")) {
                String[] stringArray = ParseUtil.whitespaces.split(string.trim());
                if (stringArray.length != 3) continue;
                arrayList.add(new OSService(stringArray[2], ParseUtil.parseIntOrDefault(stringArray[1], 0), OSService.State.RUNNING));
                continue;
            }
            if (!string.startsWith("legacy_run")) continue;
            for (String string2 : arrayList2) {
                if (!string.endsWith(string2)) continue;
                arrayList.add(new OSService(string2, 0, OSService.State.STOPPED));
                continue block1;
            }
        }
        return arrayList;
    }

    static {
        Object object = ParseUtil.whitespaces.split(ExecutingCommand.getFirstAnswer("uname -rv"));
        VERSION = object[0];
        BUILD_NUMBER = ((String[])object).length > 1 ? object[1] : "";
        ALLOW_KSTAT2 = GlobalConfig.get("oshi.os.solaris.allowKstat2", true);
        object = null;
        try {
            if (ALLOW_KSTAT2) {
                object = Kstat2.INSTANCE;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        HAS_KSTAT2 = object != null;
        BOOT_UPTIME = Memoizer.memoize(SolarisOperatingSystem::queryBootAndUptime, Memoizer.defaultExpiration());
        BOOTTIME = SolarisOperatingSystem.querySystemBootTime();
    }
}

