/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Native;
import com.sun.jna.platform.mac.SystemB;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.annotation.concurrent.ThreadSafe;
import oshi.hardware.common.AbstractVirtualMemory;
import oshi.hardware.platform.mac.MacGlobalMemory;
import oshi.jna.ByRef;
import oshi.jna.Struct;
import oshi.util.Memoizer;
import oshi.util.ParseUtil;
import oshi.util.platform.mac.SysctlUtil;
import oshi.util.tuples.Pair;

@ThreadSafe
final class MacVirtualMemory
extends AbstractVirtualMemory {
    private static final Logger LOG = LoggerFactory.getLogger(MacVirtualMemory.class);
    private final MacGlobalMemory global;
    private final Supplier<Pair<Long, Long>> usedTotal = Memoizer.memoize(MacVirtualMemory::querySwapUsage, Memoizer.defaultExpiration());
    private final Supplier<Pair<Long, Long>> inOut = Memoizer.memoize(MacVirtualMemory::queryVmStat, Memoizer.defaultExpiration());

    MacVirtualMemory(MacGlobalMemory macGlobalMemory) {
        this.global = macGlobalMemory;
    }

    @Override
    public long getSwapUsed() {
        return this.usedTotal.get().getA();
    }

    @Override
    public long getSwapTotal() {
        return this.usedTotal.get().getB();
    }

    @Override
    public long getVirtualMax() {
        return this.global.getTotal() + this.getSwapTotal();
    }

    @Override
    public long getVirtualInUse() {
        return this.global.getTotal() - this.global.getAvailable() + this.getSwapUsed();
    }

    @Override
    public long getSwapPagesIn() {
        return this.inOut.get().getA();
    }

    @Override
    public long getSwapPagesOut() {
        return this.inOut.get().getB();
    }

    private static Pair<Long, Long> querySwapUsage() {
        long l = 0L;
        long l2 = 0L;
        try (Struct.CloseableXswUsage closeableXswUsage = new Struct.CloseableXswUsage();){
            if (SysctlUtil.sysctl("vm.swapusage", closeableXswUsage)) {
                l = closeableXswUsage.xsu_used;
                l2 = closeableXswUsage.xsu_total;
            }
        }
        return new Pair<Long, Long>(l, l2);
    }

    private static Pair<Long, Long> queryVmStat() {
        long l = 0L;
        long l2 = 0L;
        try (Struct.CloseableVMStatistics closeableVMStatistics = new Struct.CloseableVMStatistics();
             ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference(closeableVMStatistics.size() / SystemB.INT_SIZE);){
            if (0 == SystemB.INSTANCE.host_statistics(SystemB.INSTANCE.mach_host_self(), 2, closeableVMStatistics, closeableIntByReference)) {
                l = ParseUtil.unsignedIntToLong(closeableVMStatistics.pageins);
                l2 = ParseUtil.unsignedIntToLong(closeableVMStatistics.pageouts);
            } else {
                LOG.error("Failed to get host VM info. Error code: {}", (Object)Native.getLastError());
            }
        }
        return new Pair<Long, Long>(l, l2);
    }
}

