/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.LastErrorException;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.W32Errors;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.W32APITypeMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class Kernel32Util
implements WinDef {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String VOLUME_GUID_PATH_PREFIX = "\\\\?\\Volume{";
    public static final String VOLUME_GUID_PATH_SUFFIX = "}\\";

    public static String getComputerName() {
        char[] cArray = new char[WinBase.MAX_COMPUTERNAME_LENGTH + 1];
        IntByReference intByReference = new IntByReference(cArray.length);
        if (!Kernel32.INSTANCE.GetComputerName(cArray, intByReference)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString(cArray);
    }

    public static void freeLocalMemory(Pointer pointer) {
        Pointer pointer2 = Kernel32.INSTANCE.LocalFree(pointer);
        if (pointer2 != null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static void freeGlobalMemory(Pointer pointer) {
        Pointer pointer2 = Kernel32.INSTANCE.GlobalFree(pointer);
        if (pointer2 != null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static void closeHandleRefs(WinNT.HANDLEByReference ... hANDLEByReferenceArray) {
        Win32Exception win32Exception = null;
        for (WinNT.HANDLEByReference hANDLEByReference : hANDLEByReferenceArray) {
            try {
                Kernel32Util.closeHandleRef(hANDLEByReference);
            }
            catch (Win32Exception win32Exception2) {
                if (win32Exception == null) {
                    win32Exception = win32Exception2;
                    continue;
                }
                win32Exception.addSuppressedReflected(win32Exception2);
            }
        }
        if (win32Exception != null) {
            throw win32Exception;
        }
    }

    public static void closeHandleRef(WinNT.HANDLEByReference hANDLEByReference) {
        Kernel32Util.closeHandle(hANDLEByReference == null ? null : hANDLEByReference.getValue());
    }

    public static void closeHandles(WinNT.HANDLE ... hANDLEArray) {
        Win32Exception win32Exception = null;
        for (WinNT.HANDLE hANDLE : hANDLEArray) {
            try {
                Kernel32Util.closeHandle(hANDLE);
            }
            catch (Win32Exception win32Exception2) {
                if (win32Exception == null) {
                    win32Exception = win32Exception2;
                    continue;
                }
                win32Exception.addSuppressedReflected(win32Exception2);
            }
        }
        if (win32Exception != null) {
            throw win32Exception;
        }
    }

    public static void closeHandle(WinNT.HANDLE hANDLE) {
        if (hANDLE == null) {
            return;
        }
        if (!Kernel32.INSTANCE.CloseHandle(hANDLE)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static String formatMessage(int n) {
        return Kernel32Util.formatMessage(n, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatMessage(int n, int n2, int n3) {
        PointerByReference pointerByReference = new PointerByReference();
        int n4 = Kernel32.INSTANCE.FormatMessage(4864, null, n, WinNT.LocaleMacros.MAKELANGID(n2, n3), pointerByReference, 0, null);
        if (n4 == 0) {
            throw new LastErrorException(Native.getLastError());
        }
        Pointer pointer = pointerByReference.getValue();
        try {
            String string = pointer.getWideString(0L);
            String string2 = string.trim();
            return string2;
        }
        finally {
            Kernel32Util.freeLocalMemory(pointer);
        }
    }

    public static String formatMessage(WinNT.HRESULT hRESULT) {
        return Kernel32Util.formatMessage(hRESULT.intValue());
    }

    public static String formatMessage(WinNT.HRESULT hRESULT, int n, int n2) {
        return Kernel32Util.formatMessage(hRESULT.intValue(), n, n2);
    }

    public static String formatMessageFromLastErrorCode(int n) {
        return Kernel32Util.formatMessage(W32Errors.HRESULT_FROM_WIN32(n));
    }

    public static String formatMessageFromLastErrorCode(int n, int n2, int n3) {
        return Kernel32Util.formatMessage(W32Errors.HRESULT_FROM_WIN32(n), n2, n3);
    }

    public static String getLastErrorMessage() {
        return Kernel32Util.formatMessageFromLastErrorCode(Kernel32.INSTANCE.GetLastError());
    }

    public static String getLastErrorMessage(int n, int n2) {
        return Kernel32Util.formatMessageFromLastErrorCode(Kernel32.INSTANCE.GetLastError(), n, n2);
    }

    public static String getTempPath() {
        WinDef.DWORD dWORD = new WinDef.DWORD(260L);
        char[] cArray = new char[dWORD.intValue()];
        if (Kernel32.INSTANCE.GetTempPath(dWORD, cArray).intValue() == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString(cArray);
    }

    public static void deleteFile(String string) {
        if (!Kernel32.INSTANCE.DeleteFile(string)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static List<String> getLogicalDriveStrings() {
        WinDef.DWORD dWORD = Kernel32.INSTANCE.GetLogicalDriveStrings(new WinDef.DWORD(0L), null);
        if (dWORD.intValue() <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        char[] cArray = new char[dWORD.intValue()];
        int n = (dWORD = Kernel32.INSTANCE.GetLogicalDriveStrings(dWORD, cArray)).intValue();
        if (n <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toStringList(cArray, 0, n);
    }

    public static int getFileAttributes(String string) {
        int n = Kernel32.INSTANCE.GetFileAttributes(string);
        if (n == -1) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return n;
    }

    public static int getFileType(String string) throws FileNotFoundException {
        int n;
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException(string);
        }
        WinNT.HANDLE hANDLE = null;
        Win32Exception win32Exception = null;
        try {
            hANDLE = Kernel32.INSTANCE.CreateFile(string, Integer.MIN_VALUE, 1, new WinBase.SECURITY_ATTRIBUTES(), 3, 128, new WinNT.HANDLEByReference().getValue());
            if (WinBase.INVALID_HANDLE_VALUE.equals(hANDLE)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            int n2 = Kernel32.INSTANCE.GetFileType(hANDLE);
            block2 : switch (n2) {
                case 0: {
                    int n3 = Kernel32.INSTANCE.GetLastError();
                    switch (n3) {
                        case 0: {
                            break block2;
                        }
                    }
                    throw new Win32Exception(n3);
                }
            }
            n = n2;
        }
        catch (Win32Exception win32Exception2) {
            try {
                win32Exception = win32Exception2;
                throw win32Exception;
            }
            catch (Throwable throwable) {
                Kernel32Util.cleanUp(hANDLE, win32Exception);
                throw throwable;
            }
        }
        Kernel32Util.cleanUp(hANDLE, win32Exception);
        return n;
    }

    public static int getDriveType(String string) {
        return Kernel32.INSTANCE.GetDriveType(string);
    }

    public static String getEnvironmentVariable(String string) {
        int n = Kernel32.INSTANCE.GetEnvironmentVariable(string, null, 0);
        if (n == 0) {
            return null;
        }
        if (n < 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        char[] cArray = new char[n];
        if ((n = Kernel32.INSTANCE.GetEnvironmentVariable(string, cArray, cArray.length)) <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString(cArray);
    }

    public static Map<String, String> getEnvironmentVariables() {
        Pointer pointer = Kernel32.INSTANCE.GetEnvironmentStrings();
        if (pointer == null) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
        try {
            Map<String, String> map = Kernel32Util.getEnvironmentVariables(pointer, 0L);
            return map;
        }
        finally {
            if (!Kernel32.INSTANCE.FreeEnvironmentStrings(pointer)) {
                throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
            }
        }
    }

    public static Map<String, String> getEnvironmentVariables(Pointer pointer, long l) {
        String string;
        int n;
        if (pointer == null) {
            return null;
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        boolean bl = Kernel32Util.isWideCharEnvironmentStringBlock(pointer, l);
        long l2 = bl ? 2L : 1L;
        long l3 = l;
        while ((n = (string = Kernel32Util.readEnvironmentStringBlockEntry(pointer, l3, bl)).length()) != 0) {
            int n2 = string.indexOf(61);
            if (n2 < 0) {
                throw new IllegalArgumentException("Missing variable value separator in " + string);
            }
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1);
            treeMap.put(string2, string3);
            l3 += (long)(n + 1) * l2;
        }
        return treeMap;
    }

    public static String readEnvironmentStringBlockEntry(Pointer pointer, long l, boolean bl) {
        long l2 = Kernel32Util.findEnvironmentStringBlockEntryEnd(pointer, l, bl);
        int n = (int)(l2 - l);
        if (n == 0) {
            return "";
        }
        int n2 = bl ? n / 2 : n;
        char[] cArray = new char[n2];
        long l3 = l;
        long l4 = bl ? 2L : 1L;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        int n3 = 0;
        while (n3 < cArray.length) {
            byte by = pointer.getByte(l3);
            if (bl) {
                byte by2 = pointer.getByte(l3 + 1L);
                cArray[n3] = ByteOrder.LITTLE_ENDIAN.equals(byteOrder) ? (char)(by2 << 8 & 0xFF00 | by & 0xFF) : (char)(by << 8 & 0xFF00 | by2 & 0xFF);
            } else {
                cArray[n3] = (char)(by & 0xFF);
            }
            ++n3;
            l3 += l4;
        }
        return new String(cArray);
    }

    public static long findEnvironmentStringBlockEntryEnd(Pointer pointer, long l, boolean bl) {
        long l2;
        long l3 = l;
        long l4 = l2 = bl ? 2L : 1L;
        byte by;
        while ((by = pointer.getByte(l3)) != 0) {
            l3 += l2;
        }
        return l3;
    }

    public static boolean isWideCharEnvironmentStringBlock(Pointer pointer, long l) {
        byte by = pointer.getByte(l);
        byte by2 = pointer.getByte(l + 1L);
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        if (ByteOrder.LITTLE_ENDIAN.equals(byteOrder)) {
            return Kernel32Util.isWideCharEnvironmentStringBlock(by2);
        }
        return Kernel32Util.isWideCharEnvironmentStringBlock(by);
    }

    private static boolean isWideCharEnvironmentStringBlock(byte by) {
        return by == 0;
    }

    public static final int getPrivateProfileInt(String string, String string2, int n, String string3) {
        return Kernel32.INSTANCE.GetPrivateProfileInt(string, string2, n, string3);
    }

    public static final String getPrivateProfileString(String string, String string2, String string3, String string4) {
        char[] cArray = new char[1024];
        Kernel32.INSTANCE.GetPrivateProfileString(string, string2, string3, cArray, new WinDef.DWORD((long)cArray.length), string4);
        return Native.toString(cArray);
    }

    public static final void writePrivateProfileString(String string, String string2, String string3, String string4) {
        if (!Kernel32.INSTANCE.WritePrivateProfileString(string, string2, string3, string4)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static final WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[] getLogicalProcessorInformation() {
        Memory memory;
        int n = new WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION().size();
        WinDef.DWORDByReference dWORDByReference = new WinDef.DWORDByReference(new WinDef.DWORD((long)n));
        while (!Kernel32.INSTANCE.GetLogicalProcessorInformation(memory = new Memory(dWORDByReference.getValue().intValue()), dWORDByReference)) {
            int n2 = Kernel32.INSTANCE.GetLastError();
            if (n2 == 122) continue;
            throw new Win32Exception(n2);
        }
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION sYSTEM_LOGICAL_PROCESSOR_INFORMATION = new WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION(memory);
        int n3 = dWORDByReference.getValue().intValue() / n;
        return (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[])sYSTEM_LOGICAL_PROCESSOR_INFORMATION.toArray(new WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[n3]);
    }

    public static final WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[] getLogicalProcessorInformationEx(int n) {
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX;
        Memory memory;
        WinDef.DWORDByReference dWORDByReference = new WinDef.DWORDByReference(new WinDef.DWORD(1L));
        while (!Kernel32.INSTANCE.GetLogicalProcessorInformationEx(n, memory = new Memory(dWORDByReference.getValue().intValue()), dWORDByReference)) {
            int n2 = Kernel32.INSTANCE.GetLastError();
            if (n2 == 122) continue;
            throw new Win32Exception(n2);
        }
        ArrayList<WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX> arrayList = new ArrayList<WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX>();
        for (int i = 0; i < dWORDByReference.getValue().intValue(); i += sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX.size) {
            sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX = WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX.fromPointer(memory.share(i));
            arrayList.add(sYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX);
        }
        return arrayList.toArray(new WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION_EX[0]);
    }

    public static final String[] getPrivateProfileSection(String string, String string2) {
        char[] cArray = new char[32768];
        if (Kernel32.INSTANCE.GetPrivateProfileSection(string, cArray, new WinDef.DWORD((long)cArray.length), string2).intValue() == 0) {
            int n = Kernel32.INSTANCE.GetLastError();
            if (n == 0) {
                return EMPTY_STRING_ARRAY;
            }
            throw new Win32Exception(n);
        }
        return new String(cArray).split("\u0000");
    }

    public static final String[] getPrivateProfileSectionNames(String string) {
        char[] cArray = new char[65536];
        if (Kernel32.INSTANCE.GetPrivateProfileSectionNames(cArray, new WinDef.DWORD((long)cArray.length), string).intValue() == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return new String(cArray).split("\u0000");
    }

    public static final void writePrivateProfileSection(String string, String[] stringArray, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            stringBuilder.append(string3).append('\u0000');
        }
        stringBuilder.append('\u0000');
        if (!Kernel32.INSTANCE.WritePrivateProfileSection(string, stringBuilder.toString(), string2)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static final List<String> queryDosDevice(String string, int n) {
        char[] cArray = new char[n];
        int n2 = Kernel32.INSTANCE.QueryDosDevice(string, cArray, cArray.length);
        if (n2 == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toStringList(cArray, 0, n2);
    }

    public static final List<String> getVolumePathNamesForVolumeName(String string) {
        int n;
        char[] cArray = new char[261];
        IntByReference intByReference = new IntByReference();
        if (!Kernel32.INSTANCE.GetVolumePathNamesForVolumeName(string, cArray, cArray.length, intByReference)) {
            n = Kernel32.INSTANCE.GetLastError();
            if (n != 234) {
                throw new Win32Exception(n);
            }
            int n2 = intByReference.getValue();
            cArray = new char[n2];
            if (!Kernel32.INSTANCE.GetVolumePathNamesForVolumeName(string, cArray, cArray.length, intByReference)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
        }
        n = intByReference.getValue();
        return Native.toStringList(cArray, 0, n);
    }

    public static final String extractVolumeGUID(String string) {
        if (string == null || string.length() <= VOLUME_GUID_PATH_PREFIX.length() + VOLUME_GUID_PATH_SUFFIX.length() || !string.startsWith(VOLUME_GUID_PATH_PREFIX) || !string.endsWith(VOLUME_GUID_PATH_SUFFIX)) {
            throw new IllegalArgumentException("Bad volume GUID path format: " + string);
        }
        return string.substring(VOLUME_GUID_PATH_PREFIX.length(), string.length() - VOLUME_GUID_PATH_SUFFIX.length());
    }

    public static final String QueryFullProcessImageName(int n, int n2) {
        String string;
        WinNT.HANDLE hANDLE = null;
        Win32Exception win32Exception = null;
        try {
            hANDLE = Kernel32.INSTANCE.OpenProcess(1040, false, n);
            if (hANDLE == null) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            string = Kernel32Util.QueryFullProcessImageName(hANDLE, n2);
        }
        catch (Win32Exception win32Exception2) {
            try {
                win32Exception = win32Exception2;
                throw win32Exception;
            }
            catch (Throwable throwable) {
                Kernel32Util.cleanUp(hANDLE, win32Exception);
                throw throwable;
            }
        }
        Kernel32Util.cleanUp(hANDLE, win32Exception);
        return string;
    }

    public static final String QueryFullProcessImageName(WinNT.HANDLE hANDLE, int n) {
        int n2 = 260;
        IntByReference intByReference = new IntByReference();
        do {
            char[] cArray = new char[n2];
            intByReference.setValue(n2);
            if (Kernel32.INSTANCE.QueryFullProcessImageName(hANDLE, n, cArray, intByReference)) {
                return new String(cArray, 0, intByReference.getValue());
            }
            n2 += 1024;
        } while (Kernel32.INSTANCE.GetLastError() == 122);
        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResource(String string, String string2, String string3) {
        byte[] byArray;
        Win32Exception win32Exception;
        block16: {
            WinDef.HMODULE hMODULE = Kernel32.INSTANCE.LoadLibraryEx(string, null, 2);
            if (hMODULE == null) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            win32Exception = null;
            Pointer pointer = null;
            int n = 0;
            byArray = null;
            try {
                Object object = null;
                try {
                    object = new Pointer(Long.parseLong(string2));
                }
                catch (NumberFormatException numberFormatException) {
                    object = new Memory(Native.WCHAR_SIZE * (string2.length() + 1));
                    ((Pointer)object).setWideString(0L, string2);
                }
                Pointer pointer2 = null;
                try {
                    pointer2 = new Pointer(Long.parseLong(string3));
                }
                catch (NumberFormatException numberFormatException) {
                    pointer2 = new Memory(Native.WCHAR_SIZE * (string3.length() + 1));
                    pointer2.setWideString(0L, string3);
                }
                WinDef.HRSRC hRSRC = Kernel32.INSTANCE.FindResource(hMODULE, pointer2, (Pointer)object);
                if (hRSRC == null) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                WinNT.HANDLE hANDLE = Kernel32.INSTANCE.LoadResource(hMODULE, hRSRC);
                if (hANDLE == null) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                n = Kernel32.INSTANCE.SizeofResource(hMODULE, hRSRC);
                if (n == 0) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                pointer = Kernel32.INSTANCE.LockResource(hANDLE);
                if (pointer == null) {
                    throw new IllegalStateException("LockResource returned null.");
                }
                byArray = pointer.getByteArray(0L, n);
            }
            catch (Win32Exception win32Exception2) {
                win32Exception = win32Exception2;
                return win32Exception;
            }
            finally {
                if (hMODULE == null || Kernel32.INSTANCE.FreeLibrary(hMODULE)) break block16;
                Win32Exception win32Exception3 = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                if (win32Exception != null) {
                    win32Exception3.addSuppressedReflected(win32Exception);
                }
                throw win32Exception3;
            }
        }
        if (win32Exception != null) {
            throw win32Exception;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<String>> getResourceNames(String string) {
        Win32Exception win32Exception;
        LinkedHashMap<String, List<String>> linkedHashMap;
        block12: {
            WinDef.HMODULE hMODULE = Kernel32.INSTANCE.LoadLibraryEx(string, null, 2);
            if (hMODULE == null) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            final ArrayList arrayList = new ArrayList();
            linkedHashMap = new LinkedHashMap<String, List<String>>();
            WinBase.EnumResTypeProc enumResTypeProc = new WinBase.EnumResTypeProc(){

                @Override
                public boolean invoke(WinDef.HMODULE hMODULE, Pointer pointer, Pointer pointer2) {
                    if (Pointer.nativeValue(pointer) <= 65535L) {
                        arrayList.add(Pointer.nativeValue(pointer) + "");
                    } else {
                        arrayList.add(pointer.getWideString(0L));
                    }
                    return true;
                }
            };
            WinBase.EnumResNameProc enumResNameProc = new WinBase.EnumResNameProc(){

                @Override
                public boolean invoke(WinDef.HMODULE hMODULE, Pointer pointer, Pointer pointer2, Pointer pointer3) {
                    String string = "";
                    string = Pointer.nativeValue(pointer) <= 65535L ? Pointer.nativeValue(pointer) + "" : pointer.getWideString(0L);
                    if (Pointer.nativeValue(pointer2) < 65535L) {
                        ((List)linkedHashMap.get(string)).add(Pointer.nativeValue(pointer2) + "");
                    } else {
                        ((List)linkedHashMap.get(string)).add(pointer2.getWideString(0L));
                    }
                    return true;
                }
            };
            win32Exception = null;
            try {
                if (!Kernel32.INSTANCE.EnumResourceTypes(hMODULE, enumResTypeProc, null)) {
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
                for (String string2 : arrayList) {
                    boolean bl;
                    linkedHashMap.put(string2, new ArrayList());
                    Pointer pointer = null;
                    try {
                        pointer = new Pointer(Long.parseLong(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        pointer = new Memory(Native.WCHAR_SIZE * (string2.length() + 1));
                        pointer.setWideString(0L, string2);
                    }
                    if (bl = Kernel32.INSTANCE.EnumResourceNames(hMODULE, pointer, enumResNameProc, null)) continue;
                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                }
            }
            catch (Win32Exception win32Exception2) {
                win32Exception = win32Exception2;
                return win32Exception;
            }
            finally {
                if (hMODULE == null || Kernel32.INSTANCE.FreeLibrary(hMODULE)) break block12;
                Win32Exception win32Exception3 = new Win32Exception(Kernel32.INSTANCE.GetLastError());
                if (win32Exception != null) {
                    win32Exception3.addSuppressedReflected(win32Exception);
                }
                throw win32Exception3;
            }
        }
        if (win32Exception != null) {
            throw win32Exception;
        }
        return linkedHashMap;
    }

    public static List<Tlhelp32.MODULEENTRY32W> getModules(int n) {
        ArrayList<Tlhelp32.MODULEENTRY32W> arrayList;
        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPMODULE, new WinDef.DWORD((long)n));
        if (hANDLE == null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Win32Exception win32Exception = null;
        try {
            Tlhelp32.MODULEENTRY32W mODULEENTRY32W = new Tlhelp32.MODULEENTRY32W();
            if (!Kernel32.INSTANCE.Module32FirstW(hANDLE, mODULEENTRY32W)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            ArrayList<Tlhelp32.MODULEENTRY32W> arrayList2 = new ArrayList<Tlhelp32.MODULEENTRY32W>();
            arrayList2.add(mODULEENTRY32W);
            Tlhelp32.MODULEENTRY32W mODULEENTRY32W2 = new Tlhelp32.MODULEENTRY32W();
            while (Kernel32.INSTANCE.Module32NextW(hANDLE, mODULEENTRY32W2)) {
                arrayList2.add(mODULEENTRY32W2);
                mODULEENTRY32W2 = new Tlhelp32.MODULEENTRY32W();
            }
            int n2 = Kernel32.INSTANCE.GetLastError();
            if (n2 != 0 && n2 != 18) {
                throw new Win32Exception(n2);
            }
            arrayList = arrayList2;
        }
        catch (Win32Exception win32Exception2) {
            try {
                win32Exception = win32Exception2;
                throw win32Exception;
            }
            catch (Throwable throwable) {
                Kernel32Util.cleanUp(hANDLE, win32Exception);
                throw throwable;
            }
        }
        Kernel32Util.cleanUp(hANDLE, win32Exception);
        return arrayList;
    }

    public static String expandEnvironmentStrings(String string) {
        if (string == null) {
            return "";
        }
        int n = Kernel32.INSTANCE.ExpandEnvironmentStrings(string, null, 0);
        if (n == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Memory memory = W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE ? new Memory(n * Native.WCHAR_SIZE) : new Memory(n + 1);
        n = Kernel32.INSTANCE.ExpandEnvironmentStrings(string, memory, n);
        if (n == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            return memory.getWideString(0L);
        }
        return memory.getString(0L);
    }

    public static WinDef.DWORD getCurrentProcessPriority() {
        WinDef.DWORD dWORD = Kernel32.INSTANCE.GetPriorityClass(Kernel32.INSTANCE.GetCurrentProcess());
        if (!Kernel32Util.isValidPriorityClass(dWORD)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return dWORD;
    }

    public static void setCurrentProcessPriority(WinDef.DWORD dWORD) {
        if (!Kernel32Util.isValidPriorityClass(dWORD)) {
            throw new IllegalArgumentException("The given priority value is invalid!");
        }
        if (!Kernel32.INSTANCE.SetPriorityClass(Kernel32.INSTANCE.GetCurrentProcess(), dWORD)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static void setCurrentProcessBackgroundMode(boolean bl) {
        WinDef.DWORD dWORD;
        WinDef.DWORD dWORD2 = dWORD = bl ? Kernel32.PROCESS_MODE_BACKGROUND_BEGIN : Kernel32.PROCESS_MODE_BACKGROUND_END;
        if (!Kernel32.INSTANCE.SetPriorityClass(Kernel32.INSTANCE.GetCurrentProcess(), dWORD)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static int getCurrentThreadPriority() {
        int n = Kernel32.INSTANCE.GetThreadPriority(Kernel32.INSTANCE.GetCurrentThread());
        if (!Kernel32Util.isValidThreadPriority(n)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return n;
    }

    public static void setCurrentThreadPriority(int n) {
        if (!Kernel32Util.isValidThreadPriority(n)) {
            throw new IllegalArgumentException("The given priority value is invalid!");
        }
        if (!Kernel32.INSTANCE.SetThreadPriority(Kernel32.INSTANCE.GetCurrentThread(), n)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static void setCurrentThreadBackgroundMode(boolean bl) {
        int n;
        int n2 = n = bl ? 65536 : 131072;
        if (!Kernel32.INSTANCE.SetThreadPriority(Kernel32.INSTANCE.GetCurrentThread(), n)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static WinDef.DWORD getProcessPriority(int n) {
        WinDef.DWORD dWORD;
        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.OpenProcess(1024, false, n);
        if (hANDLE == null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Win32Exception win32Exception = null;
        try {
            WinDef.DWORD dWORD2 = Kernel32.INSTANCE.GetPriorityClass(hANDLE);
            if (!Kernel32Util.isValidPriorityClass(dWORD2)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            dWORD = dWORD2;
        }
        catch (Win32Exception win32Exception2) {
            try {
                win32Exception = win32Exception2;
                throw win32Exception;
            }
            catch (Throwable throwable) {
                Kernel32Util.cleanUp(hANDLE, win32Exception);
                throw throwable;
            }
        }
        Kernel32Util.cleanUp(hANDLE, win32Exception);
        return dWORD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProcessPriority(int n, WinDef.DWORD dWORD) {
        if (!Kernel32Util.isValidPriorityClass(dWORD)) {
            throw new IllegalArgumentException("The given priority value is invalid!");
        }
        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.OpenProcess(512, false, n);
        if (hANDLE == null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Win32Exception win32Exception = null;
        try {
            if (!Kernel32.INSTANCE.SetPriorityClass(hANDLE, dWORD)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
        }
        catch (Win32Exception win32Exception2) {
            win32Exception = win32Exception2;
        }
        finally {
            Kernel32Util.cleanUp(hANDLE, win32Exception);
        }
    }

    public static int getThreadPriority(int n) {
        int n2;
        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.OpenThread(64, false, n);
        if (hANDLE == null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Win32Exception win32Exception = null;
        try {
            int n3 = Kernel32.INSTANCE.GetThreadPriority(hANDLE);
            if (!Kernel32Util.isValidThreadPriority(n3)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            n2 = n3;
        }
        catch (Win32Exception win32Exception2) {
            try {
                win32Exception = win32Exception2;
                throw win32Exception;
            }
            catch (Throwable throwable) {
                Kernel32Util.cleanUp(hANDLE, win32Exception);
                throw throwable;
            }
        }
        Kernel32Util.cleanUp(hANDLE, win32Exception);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setThreadPriority(int n, int n2) {
        if (!Kernel32Util.isValidThreadPriority(n2)) {
            throw new IllegalArgumentException("The given priority value is invalid!");
        }
        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.OpenThread(32, false, n);
        if (hANDLE == null) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        Win32Exception win32Exception = null;
        try {
            if (!Kernel32.INSTANCE.SetThreadPriority(hANDLE, n2)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
        }
        catch (Win32Exception win32Exception2) {
            win32Exception = win32Exception2;
        }
        finally {
            Kernel32Util.cleanUp(hANDLE, win32Exception);
        }
    }

    public static boolean isValidPriorityClass(WinDef.DWORD dWORD) {
        return Kernel32.NORMAL_PRIORITY_CLASS.equals(dWORD) || Kernel32.IDLE_PRIORITY_CLASS.equals(dWORD) || Kernel32.HIGH_PRIORITY_CLASS.equals(dWORD) || Kernel32.REALTIME_PRIORITY_CLASS.equals(dWORD) || Kernel32.BELOW_NORMAL_PRIORITY_CLASS.equals(dWORD) || Kernel32.ABOVE_NORMAL_PRIORITY_CLASS.equals(dWORD);
    }

    public static boolean isValidThreadPriority(int n) {
        switch (n) {
            case -15: 
            case -2: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    private static void cleanUp(WinNT.HANDLE hANDLE, Win32Exception win32Exception) {
        try {
            Kernel32Util.closeHandle(hANDLE);
        }
        catch (Win32Exception win32Exception2) {
            if (win32Exception == null) {
                win32Exception = win32Exception2;
            }
            win32Exception.addSuppressedReflected(win32Exception2);
        }
        if (win32Exception != null) {
            throw win32Exception;
        }
    }
}

